function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
% function residual = dynamic_resid(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   residual
%

if T_flag
    T = World_Economy_Cartel_Fracking_VD.dynamic_resid_tt(T, y, x, params, steady_state, it_);
end
residual = zeros(80, 1);
residual(1) = T(37)+T(41)+params(25)*y(138)-y(97);
residual(2) = T(26)*(-exp(y(29)))+y(103)*(-T(42))+y(89)*(-(T(31)*params(4)*exp(y(29)*params(4))))+exp(y(29))*y(73)+params(25)*y(140)-y(99)+params(25)*T(42)*y(144);
residual(3) = y(103)*(-T(43))+y(87)*(-(T(29)*params(4)*exp(y(30)*params(4))))+y(78)*y(41)*T(29)*params(4)*(params(4)-1)*exp(y(30)*(params(4)-1))+exp(y(30))*y(73)+params(25)*y(139)-y(98)+params(25)*y(144)*T(43);
residual(4) = T(26)*T(44)+y(104)*(-T(45))+y(93)*(-T(32))+T(32)*y(92)+params(25)*y(142)-y(101)+params(25)*T(45)*y(145);
residual(5) = y(104)*(-T(46))+y(93)*(-exp(y(32)))+exp(y(32))*y(90)+params(25)*y(141)-y(100)+params(25)*y(145)*T(46);
residual(6) = T(48);
residual(7) = T(50);
residual(8) = T(51);
residual(9) = T(52);
residual(10) = T(54)+params(25)*y(137)*(-exp(y(37)));
residual(11) = T(49)+y(79)*T(55)+y(76)*T(56)+params(25)*y(125)*exp(y(34))*params(6)*params(5)*exp(params(5)*y(38))+T(57);
residual(12) = exp(y(39))*y(72);
residual(13) = y(77)*(-params(7))+y(76)+T(38)*y(22)*(-(T(24)*(1-exp(y(11)))))+T(38)*T(24)*y(24);
residual(14) = params(4)*exp(y(30)*(params(4)-1))*T(29)*y(78)+y(77)+T(38)*y(23)*(-(T(24)*(1-params(7))));
residual(15) = T(8)*y(93)+y(69)*(-(params(11)*T(12)*T(58)))+y(68)*(-(params(11)*T(59)*T(60)));
residual(16) = y(73)*(-exp(y(43)))+y(71)*(-(T(5)*T(19)*T(16)*T(62)))+y(70)*(-(T(17)*T(3)*T(16)*T(63)))+y(69)*(-(T(14)*params(11)*T(61)))+exp(y(43))*y(68)+params(25)*y(143)-y(102);
residual(17) = T(20)*y(73)+params(25)*y(121)*(-(T(70)*T(73)))+params(25)*y(122)*(-(T(74)*(T(66)*T(76)*T(77)+T(67)*T(76)*T(79))))+params(25)*y(123)*T(83)+params(25)*y(124)*(-(exp((1-params(3))*y(112))*exp(T(1)*y(116))*params(3)*exp(params(3)*y(44))))+params(25)*y(125)*(-(T(20)*(1-params(10))));
residual(18) = (T(44)-exp(y(29)))*T(87)+y(75)*(-(params(1)*T(87)/T(28)))+T(4)*y(74)+y(72)*T(89)+y(71)*T(93)+y(70)*T(95)+y(68)*(-(T(60)*T(97)))+params(25)*y(126)*(-((-(T(87)*T(99)))/(T(26)*T(26))));
residual(19) = (T(44)-exp(y(29)))*T(100)+y(75)*T(101)+exp(y(46))*y(73)+params(25)*y(126)*(-((-(T(99)*T(100)))/(T(26)*T(26))));
residual(20) = exp(y(47))*y(71)+T(38)*y(21)*(-(exp(y(47))*T(24)));
residual(21) = y(74)*(-(T(21)*T(102)))+exp(y(48))*y(70);
residual(22) = T(103);
residual(23) = y(95)+params(25)*y(136)*(-params(15))+y(72)*(-(exp(y(45)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(50))))+y(71)*(-(T(5)*T(19)*T(16)*T(104)))+y(70)*(-(T(17)*T(3)*T(16)*T(105)))+y(68)*(-(T(60)*T(107)))+T(108)*(-params(16))*y(146);
residual(24) = T(111)+y(94)+T(114);
residual(25) = y(103)*(-T(115))+y(88)*(-(T(30)*params(4)*exp(y(52)*params(4))))+y(82)*y(58)*T(30)*params(4)*(params(4)-1)*exp(y(52)*(params(4)-1))+exp(y(52))*y(73)+params(25)*y(144)*T(115);
residual(26) = y(104)*(-T(116))+y(93)*(-exp(y(53)))+exp(y(53))*y(91)+params(25)*y(145)*T(116);
residual(27) = T(117);
residual(28) = T(118);
residual(29) = y(91)*T(119)+y(85)*T(120)+y(83)*params(22)*params(21)*(params(21)-1)*exp(y(56)*(params(21)-1))+y(73)*exp(y(19))*params(22)*params(21)*exp(params(21)*y(56))+T(121);
residual(30) = y(83)+y(81)*(-params(23))+y(80)+T(38)*y(25)*(-(T(24)*(1-exp(y(56)))));
residual(31) = params(4)*exp(y(52)*(params(4)-1))*T(30)*y(82)+y(81)+T(38)*y(26)*(-(T(24)*(1-params(23))));
residual(32) = y(97);
residual(33) = y(98);
residual(34) = y(99);
residual(35) = y(100);
residual(36) = y(101);
residual(37) = y(102);
residual(38) = T(26)*T(122)+exp(y(65))*y(96);
residual(39) = y(103);
residual(40) = y(104);
residual(41) = exp(y(43))-T(9)^T(10);
residual(42) = exp(y(28))-params(11)*T(12)*T(14);
residual(43) = exp(y(48))-T(3)*T(15)*T(16)*T(17);
residual(44) = exp(y(47))-T(5)*T(16)*T(18)*T(19);
residual(45) = exp(y(39))-exp(T(1)*y(50))*exp(y(13)*params(3))*exp(y(45)*(1-params(3)));
residual(46) = exp(y(46))+T(20)+exp(y(30))+exp(y(29))+exp(y(52))+params(6)*exp(params(5)*y(11))*exp(y(7))+params(22)*exp(params(21)*y(56))*exp(y(19))+params(6)*exp(params(5)*y(10))*exp(y(6))-(exp(y(43))+exp(y(13))*(1-params(10)));
residual(47) = T(4)-T(21)*exp(y(48))^T(22);
residual(48) = 1-T(23)*(1+exp(y(114))-params(10));
residual(49) = T(24)-params(1)*T(26)/T(28);
residual(50) = y(40)-T(23)*(exp(y(38))*exp(y(107))+(1-exp(y(38)))*y(108)-params(6)*exp(params(5)*y(38)));
residual(51) = y(41)-(y(40)*params(7)+T(23)*(1-params(7))*y(109));
residual(52) = y(41)*params(4)*exp(y(30)*(params(4)-1))*T(29)-1;
residual(53) = T(23)*params(6)*params(5)*exp(y(38)*(params(5)-1))-T(23)*(exp(y(107))-y(108));
residual(54) = y(57)-T(23)*(exp(y(107))*exp(y(118))+(1-exp(y(118)))*y(119)-params(22)*exp(params(21)*y(118)));
residual(55) = y(58)-(y(57)*params(23)+T(23)*(1-params(23))*y(120));
residual(56) = y(58)*params(4)*exp(y(52)*(params(4)-1))*T(30)-1;
residual(57) = params(22)*params(21)*exp(y(56)*(params(21)-1))-(exp(y(28))-y(57));
residual(58) = exp(y(34))-(exp(y(7))*(1-exp(y(11)))+params(7)*exp(y(36)));
residual(59) = exp(y(54))-(exp(y(19))*(1-exp(y(56)))+params(23)*exp(y(55)));
residual(60) = exp(y(33))-(exp(y(6))*(1-exp((-y(51)))*exp(y(10)))+params(7)*exp(y(35)));
residual(61) = exp(y(36))-((1-params(7))*exp(y(9))+T(29)*exp(y(30)*params(4)));
residual(62) = exp(y(55))-((1-params(23))*exp(y(20))+T(30)*exp(y(52)*params(4)));
residual(63) = exp(y(35))-((1-params(7))*exp(y(8))+exp(y(29)*params(4))*T(31));
residual(64) = exp(y(32))-exp(y(7))*exp(y(11));
residual(65) = exp(y(53))-exp(y(19))*exp(y(56));
residual(66) = T(32)-exp(y(6))*exp((-y(51)))*exp(y(10));
residual(67) = T(8)-T(33);
residual(68) = y(51)-x(it_, 1);
residual(69) = y(50)-(x(it_, 2)+params(15)*y(16)+params(16)*y(27));
residual(70) = exp(y(65))-exp(y(10));
residual(71) = y(59)-(y(28)-y(1));
residual(72) = y(60)-(y(30)-y(3));
residual(73) = y(61)-(y(29)-y(2));
residual(74) = y(62)-(y(32)-y(5));
residual(75) = y(63)-(y(31)-y(4));
residual(76) = y(64)-(y(43)-y(12));
residual(77) = y(66)-(log(T(34))-log(T(35)));
residual(78) = y(67)-(log(T(33))-log(T(36)));
lhs = y(105);
rhs = y(136);
residual(79) = lhs - rhs;
lhs = y(106);
rhs = y(16);
residual(80) = lhs - rhs;

end
